---
Creation date: 2024-04-04
Last modified: 2024-07-18
---
## Fleeting notes

- [ ] Call Phil re: train booking - 0754754XXX
- Temporary username: gyxpf

## To do lists

> [!task]+ Today's tasks
>  ```dataview
>TABLE without id row.file.link as Task, join(task-type) as "Task Type", join(related-areas) as Area, join(related-projects) as Project, join(do-date) as "Do Date", join(due-date) as "Due Date", join(task-size) as "Task Size", join(priority) as "Task Priority"
>FROM "Actionables/Tasks"
>WHERE done <= false AND waiting-on-someone <= false AND task-amnesty <= false AND do-date AND do-date <= date(today)
>SORT task-type DESC, choice(priority = "⚫ TBD", "1", choice(priority = "🔴 A", "2", choice(priority = "🟡 B", "3", choice(priority = "🟢 C", "4", choice(priority = "🟣 D", "5", choice(priority = "🔵 E", "6", "other")))))), choice(task-size = "🎂 Big", "1", choice(task-size = "🍰 Medium", "2", choice(task-size = "🧁 Small", "3", "other"))), priority ASC, task-size ASC, related-areas ASC, related-projects ASC
> ``` 

> [!task]- Tomorrow's tasks
> ```dataview
> TABLE without id row.file.link as Task, join(task-type) as "Task Type", join(related-areas) as Area, join(related-projects) as Project, join(do-date) as "Do Date", join(due-date) as "Due Date", join(task-size) as "Task Size", join(priority) as "Task Priority"
> FROM "Actionables/Tasks"
> WHERE done <= false AND waiting-on-someone <= false AND task-amnesty <= false AND do-date AND do-date = date(today) + dur(1 day)
> SORT task-type DESC, choice(priority = "⚫ TBD", "1", choice(priority = "🔴 A", "2", choice(priority = "🟡 B", "3", choice(priority = "🟢 C", "4", choice(priority = "🟣 D", "5", choice(priority = "🔵 E", "6", "other")))))), choice(task-size = "🎂 Big", "1", choice(task-size = "🍰 Medium", "2", choice(task-size = "🧁 Small", "3", "other"))), priority ASC, task-size ASC, related-areas ASC, related-projects ASC
> ``` 

> [!task]+ Waiting on someone
>```dataview 
>TABLE without id row.file.link as Task, join(waiting-on) as "Waiting On", join(task-type) as "Task Type", join(related-areas) as Area, join(related-projects) as Project, join(do-date) as "Do Date", join(due-date) as "Due Date", join(task-size) as "Task Size", join(priority) as "Task Priority"
>FROM "Actionables/Tasks"
>WHERE waiting-on-someone = true 
>SORT task-type DESC, choice(priority = "⚫ TBD", "1", choice(priority = "🔴 A", "2", choice(priority = "🟡 B", "3", choice(priority = "🟢 C", "4", choice(priority = "🟣 D", "5", choice(priority = "🔵 E", "6", "other")))))), choice(task-size = "🎂 Big", "1", choice(task-size = "🍰 Medium", "2", choice(task-size = "🧁 Small", "3", "other"))), priority ASC, task-size ASC, related-areas ASC, related-projects ASC
>```

> [!task]- Done today
>  ```dataview
>TABLE without id row.file.link as Task, join(task-type) as "Task Type", join(related-areas) as Area, join(related-projects) as Project, join(do-date) as "Do Date", join(due-date) as "Due Date", join(task-size) as "Task Size", join(priority) as "Task Priority"
>FROM "Actionables/Tasks"
>WHERE done = true AND do-date AND do-date = date(today)
>SORT task-type DESC, choice(priority = "⚫ TBD", "1", choice(priority = "🔴 A", "2", choice(priority = "🟡 B", "3", choice(priority = "🟢 C", "4", choice(priority = "🟣 D", "5", choice(priority = "🔵 E", "6", "other")))))), choice(task-size = "🎂 Big", "1", choice(task-size = "🍰 Medium", "2", choice(task-size = "🧁 Small", "3", "other"))), priority ASC, task-size ASC, related-areas ASC, related-projects ASC
> ``` 

## Today's practical notes

> [!meeting]+ Meeting notes past and upcoming week
> ```dataview
> TABLE without id row.file.link as "Meeting Notes", join(meeting-date) as Date, join(related-people) as People, join(related-areas) as Areas, join(related-projects) as Projects
> FROM "Project management system/Meeting notes"
> WHERE meeting-date <= (date(today) + dur(7 day)) AND meeting-date >= (date(today) - dur(7 day))
> SORT meeting-date DESC
> LIMIT 40
> ```

> [!resource]+ Resources past week
> ```dataview
> TABLE without id row.file.link as Resources, join(resource-date) as Date, join(related-people) as People, join(resource-type) as Type, join(related-areas) as Areas, join(related-projects) as Projects
> FROM "Project management system/Resources"
> WHERE resource-date > (date(today) - dur(7 day))
> SORT file.ctime DESC
> LIMIT 20
> ```

## Dashboard

> [!multi-column] Dashboard
>
>> [!resource]+ Work notes
>> - Emergency teaching room support: 029XXXXXXX
>> - [[Research funding opportunities]]
>
>> [!resource]+ Personal notes
>> - [[Family gift ideas]]
>
>> [!resource]+ Obsidian cheat sheet
>> **To find hidden files (MacOS)**
>> - All Obsidian configuration files are hidden by default, so you may need to enable “view hidden files” on your operating system.
>> - On a Mac, in Finder, you can press cmd+shift+. to toggle view hidden files
>
>> [!resource]+ Task priority code
>> ⚫ TBD - priority yet to be assigned
>> 🔴 A - most important tasks - serious consequences if not done urgently
>> 🟡 B - important tasks - no serious consequences if not done immediately
>> 🟢 C - time-sensitive tasks - would be good to do, but no real consequences if not
>> 🟣 D - can/should be delegated
>> 🔵 E - can be eliminated

> [!multi-column] Work
>
>> [!area]+ Active work areas
>> - [[Research]]
>> - [[Teaching]]
>> - [[Academic service]]
>> - [[Professional development]]
>
>> [!project]+ Active work projects
>> - [[Paper X]]
>> - [[Faculty Search Committee]]
>
>> [!project]+ Ongoing work projects
>> - [[SOC101 Introduction to Sociology Course|SOC101]]
>> - [[SOC301 Social Research Methods Course|SOC301]]
>> - [[School Ethics Committee]]
>
>> [!project]+ Waiting work projects
>> - [[Paper Y]]

> [!multi-column] Personal
>
>> [!area]+ Active personal areas
>> - [[Family & Friends]]
>> - [[Life admin]]
>> - [[Personal Knowledge Management|PKM]]
>
>> [!project]+ Active personal projects
>> - [[Wedding]]
>
>> [!project]+ Ongoing personal projects
>> - [[House renovation]]
>
>> [!project]+ Waiting personal projects
>> - [[Honeymoon]]

